/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2216;

import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.Status;
import ibm.nways.jdm2216.ContainedGraphicImage;
import ibm.nways.jdm2216.GraphicImage2216;
import ibm.nways.jdm2216.GraphicImageModule;
import java.awt.Component;
import java.awt.Image;
import java.awt.MenuItem;

public class GraphicImageModuleImpl
extends GraphicImageModule {
    private int moduleCount;
    private I18NString name;
    GraphicImage2216[] ports;
    ContainedGraphicImage grImage;

    public GraphicImageModuleImpl() {
        this.setLocation(0, 0);
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    public void setModuleCount(int n) {
        this.moduleCount = n;
        this.ports = new GraphicImage2216[n];
        int n2 = 0;
        while (n2 < n) {
            this.ports[n2] = null;
            ++n2;
        }
    }

    public GraphicImage2216 getModule(int n) {
        return this.ports[n - 1];
    }

    private void allocateModules(int n) {
        if (this.ports == null) {
            this.ports = new GraphicImage2216[this.moduleCount];
        } else if (this.moduleCount < n) {
            GraphicImage2216[] graphicImage2216Array = new GraphicImage2216[n];
            int n2 = 0;
            while (n2 < this.moduleCount) {
                graphicImage2216Array[n2] = this.ports[n2];
                this.ports = graphicImage2216Array;
                ++n2;
            }
        } else {
            return;
        }
        int n3 = this.moduleCount;
        while (n3 < n) {
            this.ports[n3] = null;
            ++n3;
        }
    }

    public void setModule(int n, GraphicImage2216 graphicImage2216) {
        if (this.ports == null) {
            this.moduleCount = n * 2;
            this.ports = new GraphicImage2216[this.moduleCount];
        } else if (this.moduleCount < n) {
            this.moduleCount = n * 2;
            GraphicImage2216[] graphicImage2216Array = new GraphicImage2216[this.moduleCount];
            int n2 = 0;
            while (n2 < this.moduleCount) {
                graphicImage2216Array[n2] = this.ports[n2];
                this.ports = graphicImage2216Array;
                ++n2;
            }
        }
        if (this.ports[n - 1] != null) {
            this.remove((Component)((Object)this.ports[n - 1]));
        }
        this.ports[n - 1] = graphicImage2216;
        this.add(graphicImage2216);
    }

    public void setImage(Image image) {
        if (this.grImage == null) {
            this.grImage = new ContainedGraphicImage();
        }
        this.grImage.setImage(image);
        this.grImage.setLocation(0, 0);
        this.grImage.setZOrder(5);
        if (image != null) {
            this.add(this.grImage);
        }
        this.setSize(this.getPreferredSize());
    }

    public void addMenuItem(int n, MenuItem menuItem) {
        this.ports[n - 1].addMenuItem(menuItem);
    }

    public void addMenuItem(MenuItem menuItem) {
        if (this.grImage != null) {
            this.grImage.addMenuItem(menuItem);
        }
    }

    public void removeMenuItem(int n, MenuItem menuItem) {
        this.ports[n - 1].removeMenuItem(menuItem);
    }

    public void removeMenuItem(MenuItem menuItem) {
        if (this.grImage != null) {
            this.grImage.removeMenuItem(menuItem);
        }
    }

    public void setStatus(int n, Status status) {
        if (n > 0 && n <= this.moduleCount) {
            status.setName(this.ports[n - 1].getI18NName());
            this.ports[n - 1].setStatus(status);
        }
    }

    public void setStatus(Status status) {
        if (this.grImage != null) {
            status.setName(this.getI18NName());
            this.grImage.setStatus(status);
        }
    }

    public Status getStatus(int n) {
        if (n > 0 && n <= this.moduleCount) {
            return this.ports[n - 1].getStatus();
        }
        return null;
    }

    public Status getStatus() {
        if (this.grImage != null) {
            return this.grImage.getStatus();
        }
        return null;
    }

    public void setAction(int n, GraphicAction graphicAction) {
        if (n > 0 && n <= this.moduleCount) {
            this.ports[n - 1].setAction(graphicAction);
        }
    }

    public void setAction(GraphicAction graphicAction) {
        if (this.grImage != null) {
            this.grImage.setAction(graphicAction);
        }
    }

    public void setFlyOver(int n, GraphicFlyOver graphicFlyOver) {
        if (n > 0 && n <= this.moduleCount) {
            this.ports[n - 1].setFlyOver(graphicFlyOver);
        }
    }

    public void setFlyOver(GraphicFlyOver graphicFlyOver) {
        if (this.grImage != null) {
            this.grImage.setFlyOver(graphicFlyOver);
        }
    }

    public void setZOrder(int n, int n2) {
        if (n > 0 && n <= this.moduleCount) {
            this.ports[n - 1].setZOrder(n2);
        }
    }

    public void setZOrder(int n) {
        if (this.grImage != null) {
            this.grImage.setZOrder(n);
        }
    }

    public int getZOrder() {
        if (this.grImage != null) {
            return this.grImage.getZOrder();
        }
        return 0;
    }

    public I18NString getI18NName() {
        return this.name;
    }

    public void setI18NName(I18NString i18NString) {
        this.name = i18NString;
        Status status = this.getStatus();
        if (status != null) {
            status.setName(i18NString);
        }
    }

    public void add(GraphicImage2216 graphicImage2216) {
        if (graphicImage2216 instanceof GraphicContainer) {
            this.add((GraphicContainer)((Object)graphicImage2216));
            return;
        }
        if (graphicImage2216 instanceof GraphicComponent) {
            this.add((GraphicComponent)((Object)graphicImage2216));
            return;
        }
        this.add((Component)((Object)graphicImage2216));
    }
}

